#!/bin/bash -
#===============================================================================
#
#          FILE: updateAdminUser.sh
#
#         USAGE: ./updateAdminUser.sh
#
#   DESCRIPTION: Waits for the ORCL listener to come up and then updates an
#                admin user in the Liferay schema for general use by the 
#                developers
#
#       OPTIONS: ---
#  REQUIREMENTS: ---
#          BUGS: ---
#         NOTES: ---
#        AUTHOR: EGBERT, BARRY
#  ORGANIZATION:
#       CREATED: 10/30/2015
#      REVISION:  1.0
#===============================================================================

# This logic ensure that the Oracle service is up and running before executing the update script.
output=$(echo "exit;" | sudo su - oracle -c "sqlplus LIFERAY_LDB/liferay_LDB@ORCL 2>&1" | grep -c "Connected to")
while [ $output -ne 1 ]; do
	sleep 5s
	output=$(echo "exit;" | sudo su - oracle -c "sqlplus LIFERAY_LDB/liferay_LDB@ORCL 2>&1" | grep -c "Connected to")
done

# Update the admin user.
sudo su - oracle -c "sqlplus LIFERAY_LDB/liferay_LDB@ORCL @/vagrant/sql/liferay/update_liferay_admin.sql >> /data/logs/update_liferay_admin.log"

